<?php

/**
 * Application component used for user operations, checking privileges, etc.
 * @author Imaginalis Software TM
 * @link http://imaginalis.pl
 */
class CreativeUser extends CWebUser
{
	/**
     * Overrides a Yii method that is used for roles in controllers (accessRules).
     *
     * @param string $operation Name of the operation required (here, a role).
     * @param mixed $params (opt) Parameters for this operation, usually the object to access.
     * @return bool Permission granted?
     */
    public function checkAccess($operation, $params=array())
    {
        if (empty($this->id)) {
            // Not identified => no rights
            return false;
        }

        $role = $this->getState("role");

        if ($role === 'admin') {
            return true; // admin role has access to everything
        }
        // allow access if the operation request is the current user's role
        return ($operation === $role);
    }

	public function getIsAdministrator()
	{
		return !$this->getIsGuest() && $this->type == 0;
	}

	public function getIsTeacher()
	{
		return !$this->getIsGuest() && $this->type == 1;
	}

	public function getIsStudent()
	{
		return !$this->getIsGuest() && $this->type == 2;
	}

	public function getIsSchoolAdministrator()
	{
		return !$this->getIsGuest() && $this->type == 3;
	}
}